#!/bin/bash
#
# Del user in /mnt/factory/shadow
set -e
if [ $# -lt 1 ]; then
        echo "Missing arguments."
        echo "Usage: $0 <username>"
        exit 1
fi

FACTORY_MNT="/mnt/factory/"
ETC_MNT="/etc/"
USER=$1
LINECOUNT=0
LINE=""

[ -f /etc/shadow ] && LINECOUNT="$(cat /etc/shadow | grep "^$USER:" | wc -l)"
if [ $LINECOUNT -eq 0 ]; then
	echo "Invalid user $USER"
	exit 2
fi

LINE="$(cat /etc/shadow | grep "^$USER:")"
TYPE="$( echo "$LINE" | cut -d':' -f2 | cut -d'$' -f2 )"
if [ "$TYPE" != "6" ] && [ "$USER" != "user" ]; then
	echo "Unable to remove system user $USER"
	exit 3
fi

if [ "admin" == "${USER}" ] || [ "root" == "${USER}" ] || [ "app" == "${USER}" ]; then
	echo "$USER user can not be removed"
	exit 4
fi

rm -f "${ETC_MNT}shadow" && cp "${FACTORY_MNT}shadow" "${ETC_MNT}"
rm -f "${ETC_MNT}group" && cp "${FACTORY_MNT}group" "${ETC_MNT}"
rm -f "${ETC_MNT}passwd" && cp "${FACTORY_MNT}passwd" "${ETC_MNT}"
userdel "${USER}"
[ -d "/home/${USER}" ] && rm -rf "/home/${USER}"

mount -o remount,rw "${FACTORY_MNT}"
cp "${ETC_MNT}shadow" "${FACTORY_MNT}" && chgrp shadow "${FACTORY_MNT}shadow"
cp "${ETC_MNT}group" "${FACTORY_MNT}" && chmod 644 "${FACTORY_MNT}group"
cp "${ETC_MNT}passwd" "${FACTORY_MNT}" && chmod 644 "${FACTORY_MNT}passwd"
ln -sfb "${FACTORY_MNT}shadow" "${ETC_MNT}shadow"
ln -sfb "${FACTORY_MNT}group" "${ETC_MNT}group"
ln -sfb "${FACTORY_MNT}passwd" "${ETC_MNT}passwd"
sync
mount -o remount,ro "${FACTORY_MNT}"

exit 0

